<?php
// Database connection (adjust the parameters according to your setup)
include "../db.php";
include "../auth.php";
include './populate_excluded_gl_accounts.php';

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
        <title>Donis | Marketers Transaction Report</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
        <meta content="Themesbrand" name="author" />

        <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css">
        <link href="assets/libs/spectrum-colorpicker2/spectrum.min.css" rel="stylesheet" type="text/css">
        <link href="assets/libs/bootstrap-timepicker/css/bootstrap-timepicker.min.css" rel="stylesheet" type="text/css">
        <link href="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css" rel="stylesheet" type="text/css" />
        <link rel="stylesheet" href="assets/libs/%40chenfengyuan/datepicker/datepicker.min.css">

        <!-- App favicon -->
        <!-- <link rel="shortcut icon" href="assets/images/favicon.ico"> -->
        <link rel="shortcut icon" type="image/x-icon" href="assets/images/donis.ico">

        <!-- DataTables -->
        <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css" rel="stylesheet" type="text/css" />

        <!-- Responsive datatable examples -->
        <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet" type="text/css" />   
        <!--For column datatables -->  
        <link href="assets/cs/jquery.dataTables.min.css"/>
        <link href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.min.css"/>

        <!-- Bootstrap Css -->
        <link href="assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <!-- Icons Css -->
        <link href="assets/css/icons.min.css" rel="stylesheet" type="text/css" />
        <!-- App Css-->
        <link href="assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />


</head>
<body>

<div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <?php include "reportheader2.php"?>

                                        <h4 class="card-title" style="margin-top:30px;margin-bottom: -20px;">Marketers Transaction Report</h4><br/>
                                        
                                        
                                            <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                                            <div style="margin-top: 20px;" class="row">
                                                <!-- <div class="col-xl-3">
                                                <div>
                                                    <h4 class="font-size-14 mb-3">Date From:</h4>
                                                    <div class="docs-datepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control docs-date" name="from"
                                                                placeholder="Pick a date" autocomplete="off">
                                                            <button type="button"
                                                                class="btn btn-secondary docs-datepicker-trigger"
                                                                disabled>
                                                                <i class="mdi mdi-calendar" aria-hidden="true"></i>
                                                            </button>
                                                        </div>
                                                        <div class="docs-datepicker-container"></div>
                                                    </div>
                                                </div>
                                                </div> -->

                                                <!-- <div class="col-xl-3">
                                                <div>
                                                    <h4 class="font-size-14 mb-3">Date To:</h4>
                                                    <div class="docs-datepicker">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control docs-date" name="to"
                                                                placeholder="Pick a date" autocomplete="off">
                                                            <button type="button" name="submit" 
                                                                class="btn btn-secondary docs-datepicker-trigger"
                                                                disabled>
                                                                <i class="mdi mdi-calendar" aria-hidden="true"></i>
                                                            </button>
                                                        </div>
                                                        <div class="docs-datepicker-container"></div>
                                                    </div>
                                                </div>
                                                </div> -->



                                                <div class="col-xl-3">
                                                    <h4 class="font-size-14 mb-3">Select Account Officer</h4>
                                                        <select name="fullname" id="formrow-inputState" class="form-select" required>
                                                                    <option value="">Select Account Officer</option>
                                                                    <?php 
                                                                    $sql ="SELECT * FROM staff_tbl WHERE status='undelete'";
                                                                    $result= mysqli_query($conn,$sql);
                                                                    while($rows = mysqli_fetch_assoc($result)){
                                                                        $lastname=$rows['lastname'];
                                                                        $firstname=$rows['firstname'];
                                                                        $fullname=$lastname." ".$firstname;
                                                                    ?>
                                                                    <option value="<?php echo ucwords($fullname);?>"><?php echo ucwords($fullname);?></option>
                                                                    <?php }
                                                                    ?>     
                                                        </select>
                                                    </div>

                                                

                                                <div class="col-xl-3">
                                                <div><br/>
                                                    
                                                    <button style="margin-top: 12px;" type="submit" name="submit" class="btn btn-primary waves-effect waves-light">
                                                    <i class="bx bxs-report font-size-16 align-middle me-2"></i> View Report</button>
                                                </div>
                                            </div>
                                        <div class="row" style="margin-top:50px;">
                                        <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap w-100">
                                            <thead>
                                            <tr>
                                                <th>SN</th>
                                                <th>TRANS DATE</th>
                                                <th>PREVIOUS BALANCE</th>
                                                <th>DEPOSIT</th>
                                                <th>BALANCE</th>
                                                <th>WITHDRAWAL</th>
                                                <th>NEW BALANCE</th>                
                                            </tr>
                                            </thead>
        
                                            <tbody>
                                            <?php
                                            $i = 1;
                                            $total = 0;
                                            $balance = 0;
                                            $previousBalance = 0;
                                            $newBalance = 0;
                                            if($_SERVER["REQUEST_METHOD"]=="POST"){
                                                  if(isset($_POST['submit'])){
                                                    // $from=date('Y-m-d',strtotime($_POST['from']));
                                                    // $to=date('Y-m-d',strtotime($_POST['to']));
                                                    $accountoff= $_POST['fullname'];

                                                    if(isset($_SESSION['excluded_accounts'])) {
                                                        // Retrieve the array from session
                                                        $excluded_accounts = $_SESSION['excluded_accounts'];
                                                    
                                                        // Dynamically build the `NOT LIKE` conditions
                                                        $not_like_conditions = implode(" AND account_number NOT LIKE ", $excluded_accounts);

                                                        $today_date = date('Y-m-d');
                                                    
                                                        // $sql ="SELECT SUM(credit) as total_deposit, SUM(debit) as total_withdrawal FROM deposit_savings_tbl 
                                                        // WHERE account_number NOT LIKE $not_like_conditions AND status!='Processing' 
                                                        // AND status2!='delete' AND trans_date < '$today_date' ORDER BY trans_date DESC LIMIT 1";
                                                        // $result = $conn->query($sql);
                                                        // if ($result->num_rows > 0) {
                                                        //     $rows = mysqli_fetch_assoc($result);
                                                        //     $deposit = $rows['total_deposit'];
                                                        //     $withdrawal = $rows['total_withdrawal'];
                                                        //     $previousBalance = $deposit - $withdrawal;
                                                        // } else {
                                                        //      $previousBalance = 0; // If no previous balance, default to 0
                                                        // }
    
                                                    $sql ="SELECT SUM(credit) as total_deposit, SUM(debit) as total_withdrawal, trans_date
                                                    FROM deposit_savings_tbl WHERE account_officer = '$accountoff' 
                                                    AND account_number NOT LIKE $not_like_conditions AND status!='Processing' AND status2!='delete' GROUP BY trans_date ORDER BY trans_date ASC";
                                                    $query = mysqli_query($conn,$sql);
                                                    while($rows = mysqli_fetch_assoc($query)){
                                                        $transdate = $rows['trans_date'];
                                                        $deposit = $rows['total_deposit'];
                                                        $withdrawal = $rows['total_withdrawal'];
                                                        $balance = $deposit - $withdrawal;
                                                        $balance = $previousBalance + $deposit;
                                                        //Calculate new balance
                                                        $newBalance = $balance - $withdrawal;
                                                        // $previousBalance += $newBalance;
                                            ?>
                                            <tr>
                                                <td><?php echo $i;?></td>
                                                <td><?php echo $transdate;?></td>
                                                <td><?php echo number_format($previousBalance);?></td>
                                                <td><?php echo number_format($deposit);?></td>
                                                <td><?php echo number_format($balance);?></td>
                                                <td><?php echo number_format($withdrawal);?></td>
                                                <td><?php echo number_format($newBalance);?></td>
                                            </tr>
                                        <?php // Set previous balance for the next row
                                                $previousBalance = $newBalance; $i++; }
                                                }}}?>
                                            </tbody>
                                            <tfoot>
                                                <th>Total</th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tfoot>
                                            
                                        </table>
                                    </div>

                                            </div>
                                        </form>

                                    </div>
                                      
                                    </div>
                                </div>
                            </div> <!-- end col -->
                        </div> <!-- end row -->

        <!-- JAVASCRIPT -->
        <script src="assets/libs/jquery/jquery.min.js"></script>
        <script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="assets/libs/metismenu/metisMenu.min.js"></script>
        <script src="assets/libs/simplebar/simplebar.min.js"></script>
        <script src="assets/libs/node-waves/waves.min.js"></script>

        <!-- Required datatable js -->
        <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
        <!-- Buttons examples -->
        <script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables.net-buttons-bs4/js/buttons.bootstrap4.min.js"></script>
        <script src="assets/libs/jszip/jszip.min.js"></script>
        <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
        <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.colVis.min.js"></script>
        
        <!-- Responsive examples -->
        <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>

        <!-- Datatable init js -->
        <script src="assets/js/pages/datatables.init.js"></script>    
        <script src="assets/js/app.js"></script>


          <!-- form advanced init -->
        <script src="assets/js/pages/form-advanced.init.js"></script>
        <script src="assets/js/app.js"></script>


        <!-- Datepicker-->
        <script src="assets/libs/select2/js/select2.min.js"></script>
        <script src="assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
        <script src="assets/libs/spectrum-colorpicker2/spectrum.min.js"></script>
        <script src="assets/libs/bootstrap-timepicker/js/bootstrap-timepicker.min.js"></script>
        <script src="assets/libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.js"></script>
        <script src="assets/libs/bootstrap-maxlength/bootstrap-maxlength.min.js"></script>
        <script src="assets/libs/%40chenfengyuan/datepicker/datepicker.min.js"></script>

        <!-- form advanced init -->
        <script src="assets/js/pages/form-advanced.init.js"></script>
        <script src="assets/js/app.js"></script>
</body>
</html>