<?php
include "../db.php";
include "../auth.php";
include './populate_excluded_gl_accounts.php';

function getCustomerBalanceReport($conn,$not_like_conditions) {
    $sql = "SELECT savings_type, account_number, cust_name, account_officer, checked, 
            SUM(COALESCE(CASE WHEN entry_type = 'credit' THEN amount END, 0)) AS total_credits,
            SUM(COALESCE(CASE WHEN entry_type = 'debit' THEN amount END, 0)) AS total_debits,
            SUM(COALESCE(CASE WHEN entry_type = 'credit' AND status='Confirmed' THEN amount END, 0)) -
            SUM(COALESCE(CASE WHEN entry_type = 'debit' AND status='Confirmed' THEN amount END, 0)) AS balance
            FROM deposit_savings_tbl
            WHERE account_number NOT LIKE $not_like_conditions AND status!='Processing'
            GROUP BY account_number
            HAVING balance <> 0";
    return mysqli_query($conn, $sql);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Donis | Customer Balance Report</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" type="image/x-icon" href="assets/images/donis.ico">
    
    <!-- CSS Files -->
    <link href="assets/libs/select2/css/select2.min.css" rel="stylesheet">
    <link href="assets/libs/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <link href="assets/libs/spectrum-colorpicker2/spectrum.min.css" rel="stylesheet">
    <link href="assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css" rel="stylesheet">
    <link href="assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/icons.min.css" rel="stylesheet">
    <link href="assets/css/app.min.css" rel="stylesheet">
</head>
<body>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <?php include "reportheader.php"; ?>

                <h4 class="card-title" style="margin:30px 0 -20px;">Customers Balance Report</h4>

                <div class="row mt-5">
                    <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap w-100">
                        <thead>
                        <tr>
                            <th>SN</th>
                            <th>SAVINGS TYPE</th>
                            <th>Account Number</th>
                            <th>Account Name</th>
                            <th>Account Officer</th>
                            <th>Total Deposit</th>
                            <th>Total Withdrawal</th>
                            <th>Balance</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        if(isset($_SESSION['excluded_accounts'])) {
                            // Retrieve the array from session
                            $excluded_accounts = $_SESSION['excluded_accounts'];
                        
                            // Dynamically build the `NOT LIKE` conditions
                            $not_like_conditions = implode(" AND account_number NOT LIKE ", $excluded_accounts);
                            $result = getCustomerBalanceReport($conn,$not_like_conditions);
                            $i = 1;
                            $total = 0;
                            while ($row = mysqli_fetch_assoc($result)) {
                            $total_deposit = $row['total_credits'];
                            $total_withdrawal = $row['total_debits'];
                            $balance = $row['balance'];
                            $total += $balance;
                            $color = ($row['checked'] == 'checked') ? 'green' : 'orange';
                            $text = ($row['checked'] == 'checked') ? 'checked' : 'unchecked';
                        ?>
                        <tr>
                            <td><?= $i++; ?></td>
                            <td><?= $row['savings_type']; ?></td>
                            <td><?= trim($row['account_number']); ?></td>
                            <td><?= $row['cust_name']; ?></td>
                            <td><?= $row['account_officer']; ?></td>
                            <td><?= number_format($total_deposit, 2); ?></td>
                            <td><?= number_format($total_withdrawal, 2); ?></td>
                            <td><?= number_format($balance, 2); ?></td>
                        </tr>
                        <?php }} ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <th>Total</th>
                            <th></th>
                            <th></th>
                            <th></th>
                            <th colspan="3"></th>
                            <th><?= number_format($total, 2); ?></th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript Files -->
<script src="assets/libs/jquery/jquery.min.js"></script>
<script src="assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js"></script>
<script src="assets/js/pages/datatables.init.js"></script>
<script src="assets/js/app.js"></script>

<script>
    function checkds(id) {
        if (confirm("Daily Savings WTD Checker!")) {
            window.location.href = "checkdailysavings2.php?checkds=" + id;
        }
    }

    function unchecked() {
        if (confirm("Are you sure you want to unchecked all!")) {
            window.location.href = "uncheckeddailysaving2.php";
        }
    }
</script>
</body>
</html>
